# setup SCA, ROIs, etc for channel CHAN 
dbLoadRecords("xspress3_AttrReset.template", "P=$(PREFIX),R=det1:,CHAN=$(CHAN)")

#ROIs: take 2D array and turn it into two 1D spectra for each channel: 
# 1 for per-frame spectra, 1 for accumulated spectra (using PROC plugin to do accumulation)
NDROIConfigure("CHAN$(CHAN)", "$(QSIZE)", 0, "XSP3", 0, -1, -1)
dbLoadRecords("NDROI.template", "P=$(PREFIX), R=ROI$(CHAN):, PORT=CHAN$(CHAN), TIMEOUT=1, ADDR=0, NDARRAY_PORT=$(PORT), NDARRAY_ADDR=0, Enabled=0")

NDROIConfigure("CHANSUM$(CHAN)", "$(QSIZE)", 0, "PROC1", 0, -1, -1)
dbLoadRecords("NDROI.template", "P=$(PREFIX), R=ROISUM$(CHAN):, PORT=CHANSUM$(CHAN), TIMEOUT=1, ADDR=0, NDARRAY_PORT=PROC1, NDARRAY_ADDR=0, Enabled=0")

#SCAs: create an NDAttribute plugin with 9 attributes
NDAttrConfigure("$(PORT).C$(CHAN)SCA", "$(QSIZE)", 0, "$(PORT)", 0, 12)
dbLoadRecords("NDAttribute.template",  "P=$(PREFIX),R=C$(CHAN)SCA:,   PORT=$(PORT).C$(CHAN)SCA, ADDR=0,TIMEOUT=1,NCHANS=$(MAXFRAMES),NDARRAY_PORT=$(PORT)")

dbLoadRecords("NDAttributeN.template", "P=$(PREFIX),R=C$(CHAN)SCA:0:,  PORT=$(PORT).C$(CHAN)SCA, ADDR=0,TIMEOUT=1,NCHANS=$(MAXFRAMES)")
dbLoadRecords("NDAttributeN.template", "P=$(PREFIX),R=C$(CHAN)SCA:1:,  PORT=$(PORT).C$(CHAN)SCA, ADDR=1,TIMEOUT=1,NCHANS=$(MAXFRAMES)")
dbLoadRecords("NDAttributeN.template", "P=$(PREFIX),R=C$(CHAN)SCA:2:,  PORT=$(PORT).C$(CHAN)SCA, ADDR=2,TIMEOUT=1,NCHANS=$(MAXFRAMES)")
dbLoadRecords("NDAttributeN.template", "P=$(PREFIX),R=C$(CHAN)SCA:3:,  PORT=$(PORT).C$(CHAN)SCA, ADDR=3,TIMEOUT=1,NCHANS=$(MAXFRAMES)")
dbLoadRecords("NDAttributeN.template", "P=$(PREFIX),R=C$(CHAN)SCA:4:,  PORT=$(PORT).C$(CHAN)SCA, ADDR=4,TIMEOUT=1,NCHANS=$(MAXFRAMES)")
dbLoadRecords("NDAttributeN.template", "P=$(PREFIX),R=C$(CHAN)SCA:5:,  PORT=$(PORT).C$(CHAN)SCA, ADDR=5,TIMEOUT=1,NCHANS=$(MAXFRAMES)")
dbLoadRecords("NDAttributeN.template", "P=$(PREFIX),R=C$(CHAN)SCA:6:,  PORT=$(PORT).C$(CHAN)SCA, ADDR=6,TIMEOUT=1,NCHANS=$(MAXFRAMES)")
dbLoadRecords("NDAttributeN.template", "P=$(PREFIX),R=C$(CHAN)SCA:7:,  PORT=$(PORT).C$(CHAN)SCA, ADDR=7,TIMEOUT=1,NCHANS=$(MAXFRAMES)")
dbLoadRecords("NDAttributeN.template", "P=$(PREFIX),R=C$(CHAN)SCA:8:,  PORT=$(PORT).C$(CHAN)SCA, ADDR=8,TIMEOUT=1,NCHANS=$(MAXFRAMES)")
dbLoadRecords("NDAttributeN.template", "P=$(PREFIX),R=C$(CHAN)SCA:9:,  PORT=$(PORT).C$(CHAN)SCA, ADDR=9,TIMEOUT=1,NCHANS=$(MAXFRAMES)")
dbLoadRecords("NDAttributeN.template", "P=$(PREFIX),R=C$(CHAN)SCA:10:,  PORT=$(PORT).C$(CHAN)SCA, ADDR=10,TIMEOUT=1,NCHANS=$(MAXFRAMES)")

NDTimeSeriesConfigure("$(PORT).C$(CHAN)SCA_TS", "$(QSIZE)", 0, "$(PORT)", 0, 12)
dbLoadRecords("$(ADCORE)/db/NDTimeSeries.template", "P=$(PREFIX),R=C$(CHAN)SCA:TS:, PORT=$(PORT).C$(CHAN)SCA_TS, ADDR=0,TIMEOUT=1,NDARRAY_PORT=$(PORT).C$(CHAN)SCA,NDARRAY_ADDR=1,NCHANS=$(MAXFRAMES),ENABLED=1")

dbLoadRecords("NDTimeSeriesN.template", "P=$(PREFIX),R=C$(CHAN)SCA:TS:0:, NAME='CHAN$(CHAN)SCA0', PORT=$(PORT).C$(CHAN)SCA_TS, ADDR=0,TIMEOUT=1,NCHANS=$(MAXFRAMES)")
dbLoadRecords("NDTimeSeriesN.template", "P=$(PREFIX),R=C$(CHAN)SCA:TS:1:, NAME='CHAN$(CHAN)SCA1', PORT=$(PORT).C$(CHAN)SCA_TS, ADDR=1,TIMEOUT=1,NCHANS=$(MAXFRAMES)")
dbLoadRecords("NDTimeSeriesN.template", "P=$(PREFIX),R=C$(CHAN)SCA:TS:2:, NAME='CHAN$(CHAN)SCA2', PORT=$(PORT).C$(CHAN)SCA_TS, ADDR=2,TIMEOUT=1,NCHANS=$(MAXFRAMES)")
dbLoadRecords("NDTimeSeriesN.template", "P=$(PREFIX),R=C$(CHAN)SCA:TS:3:, NAME='CHAN$(CHAN)SCA3', PORT=$(PORT).C$(CHAN)SCA_TS, ADDR=3,TIMEOUT=1,NCHANS=$(MAXFRAMES)")
dbLoadRecords("NDTimeSeriesN.template", "P=$(PREFIX),R=C$(CHAN)SCA:TS:4:, NAME='CHAN$(CHAN)SCA4', PORT=$(PORT).C$(CHAN)SCA_TS, ADDR=4,TIMEOUT=1,NCHANS=$(MAXFRAMES)")
dbLoadRecords("NDTimeSeriesN.template", "P=$(PREFIX),R=C$(CHAN)SCA:TS:5:, NAME='CHAN$(CHAN)SCA5', PORT=$(PORT).C$(CHAN)SCA_TS, ADDR=5,TIMEOUT=1,NCHANS=$(MAXFRAMES)")
dbLoadRecords("NDTimeSeriesN.template", "P=$(PREFIX),R=C$(CHAN)SCA:TS:6:, NAME='CHAN$(CHAN)SCA6', PORT=$(PORT).C$(CHAN)SCA_TS, ADDR=6,TIMEOUT=1,NCHANS=$(MAXFRAMES)")
dbLoadRecords("NDTimeSeriesN.template", "P=$(PREFIX),R=C$(CHAN)SCA:TS:7:, NAME='CHAN$(CHAN)SCA7', PORT=$(PORT).C$(CHAN)SCA_TS, ADDR=7,TIMEOUT=1,NCHANS=$(MAXFRAMES)")
dbLoadRecords("NDTimeSeriesN.template", "P=$(PREFIX),R=C$(CHAN)SCA:TS:8:, NAME='CHAN$(CHAN)EventWidth', PORT=$(PORT).C$(CHAN)SCA_TS, ADDR=8,TIMEOUT=1,NCHANS=$(MAXFRAMES)")
dbLoadRecords("NDTimeSeriesN.template", "P=$(PREFIX),R=C$(CHAN)SCA:TS:9:, NAME='CHAN$(CHAN)DTFactor',  PORT=$(PORT).C$(CHAN)SCA_TS, ADDR=9,TIMEOUT=1,NCHANS=$(MAXFRAMES)")
dbLoadRecords("NDTimeSeriesN.template", "P=$(PREFIX),R=C$(CHAN)SCA:TS:10:, NAME='CHAN$(CHAN)DTPercent', PORT=$(PORT).C$(CHAN)SCA_TS, ADDR=10,TIMEOUT=1,NCHANS=$(MAXFRAMES)")

dbLoadRecords("xspress3ChannelSCAThreshold.template", "P=$(PREFIX),R=det1:,PORT=$(PORT), ADDR=$(CHM1), TIMEOUT=1, CHAN=$(CHAN), SCA=4")
dbLoadRecords("xspress3ChannelSCALimits.template",    "P=$(PREFIX),R=det1:,PORT=$(PORT), ADDR=$(CHM1), TIMEOUT=1, CHAN=$(CHAN), SCA=5")
dbLoadRecords("xspress3ChannelSCALimits.template",    "P=$(PREFIX),R=det1:,PORT=$(PORT), ADDR=$(CHM1), TIMEOUT=1, CHAN=$(CHAN), SCA=6")
dbLoadRecords("xspress3ChannelDTC.template",          "P=$(PREFIX),R=det1:,PORT=$(PORT), CHAN=$(CHAN),  NDARRAY_PORT=$(PORT),ADDR=$(CHM1),TIMEOUT=5")
dbLoadRecords("xspress3ChannelDeadtime.template",     "P=$(PREFIX),R=det1:,PORT=$(PORT), ADDR=$(CHM1), TIMEOUT=1, CHAN=$(CHAN)")

#MCAs: create StdArray for Visualization: 
NDStdArraysConfigure("MCA$(CHAN)", 5, 0, "CHAN$(CHAN)", 0, 0)
dbLoadRecords("$(ADCORE)/db/NDStdArrays.template", "P=$(PREFIX),R=MCA$(CHAN):,PORT=MCA$(CHAN),ADDR=0,TIMEOUT=1,NDARRAY_PORT=CHAN$(CHAN),TYPE=Float64,FTVL=DOUBLE,NELEMENTS=$(NUM_BINS)")

NDStdArraysConfigure("MCASUM$(CHAN)", 5, 0, "CHANSUM$(CHAN)", 0, 0)
dbLoadRecords("$(ADCORE)/db/NDStdArrays.template", "P=$(PREFIX),R=MCASUM$(CHAN):,PORT=MCASUM$(CHAN),ADDR=0,TIMEOUT=1,NDARRAY_PORT=CHANSUM$(CHAN),TYPE=Float64,FTVL=DOUBLE,NELEMENTS=$(NUM_BINS)")

#ROIStats: build 48 ROIs for each of the 1D spectra (per-frame).
NDROIStatConfigure("ROISTAT$(CHAN)", "$(QSIZE)", 0, "CHAN$(CHAN)", 0, 48, 0, 0)
dbLoadRecords("NDROIStat.template",   "P=$(PREFIX),R=MCA$(CHAN)ROI: ,PORT=ROISTAT$(CHAN),ADDR=0,TIMEOUT=1, NDARRAY_PORT=CHAN$(CHAN),NCHANS=$(MAXFRAMES)")
dbLoadRecords("NDROIStatN.template",  "P=$(PREFIX),R=MCA$(CHAN)ROI:1:,PORT=ROISTAT$(CHAN),ADDR=0,TIMEOUT=1,NCHANS=$(MAXFRAMES)")
dbLoadRecords("NDROIStatN.template",  "P=$(PREFIX),R=MCA$(CHAN)ROI:2:,PORT=ROISTAT$(CHAN),ADDR=1,TIMEOUT=1,NCHANS=$(MAXFRAMES)")
dbLoadRecords("NDROIStatN.template",  "P=$(PREFIX),R=MCA$(CHAN)ROI:3:,PORT=ROISTAT$(CHAN),ADDR=2,TIMEOUT=1,NCHANS=$(MAXFRAMES)")
dbLoadRecords("NDROIStatN.template",  "P=$(PREFIX),R=MCA$(CHAN)ROI:4:,PORT=ROISTAT$(CHAN),ADDR=3,TIMEOUT=1,NCHANS=$(MAXFRAMES)")
dbLoadRecords("NDROIStatN.template",  "P=$(PREFIX),R=MCA$(CHAN)ROI:5:,PORT=ROISTAT$(CHAN),ADDR=4,TIMEOUT=1,NCHANS=$(MAXFRAMES)")
dbLoadRecords("NDROIStatN.template",  "P=$(PREFIX),R=MCA$(CHAN)ROI:6:,PORT=ROISTAT$(CHAN),ADDR=5,TIMEOUT=1,NCHANS=$(MAXFRAMES)")
dbLoadRecords("NDROIStatN.template",  "P=$(PREFIX),R=MCA$(CHAN)ROI:7:,PORT=ROISTAT$(CHAN),ADDR=6,TIMEOUT=1,NCHANS=$(MAXFRAMES)")
dbLoadRecords("NDROIStatN.template",  "P=$(PREFIX),R=MCA$(CHAN)ROI:8:,PORT=ROISTAT$(CHAN),ADDR=7,TIMEOUT=1,NCHANS=$(MAXFRAMES)")
dbLoadRecords("NDROIStatN.template",  "P=$(PREFIX),R=MCA$(CHAN)ROI:9:,PORT=ROISTAT$(CHAN),ADDR=8,TIMEOUT=1,NCHANS=$(MAXFRAMES)")
dbLoadRecords("NDROIStatN.template",  "P=$(PREFIX),R=MCA$(CHAN)ROI:10:,PORT=ROISTAT$(CHAN),ADDR=9,TIMEOUT=1,NCHANS=$(MAXFRAMES)")
dbLoadRecords("NDROIStatN.template",  "P=$(PREFIX),R=MCA$(CHAN)ROI:11:,PORT=ROISTAT$(CHAN),ADDR=10,TIMEOUT=1,NCHANS=$(MAXFRAMES)")
dbLoadRecords("NDROIStatN.template",  "P=$(PREFIX),R=MCA$(CHAN)ROI:12:,PORT=ROISTAT$(CHAN),ADDR=11,TIMEOUT=1,NCHANS=$(MAXFRAMES)")
dbLoadRecords("NDROIStatN.template",  "P=$(PREFIX),R=MCA$(CHAN)ROI:13:,PORT=ROISTAT$(CHAN),ADDR=12,TIMEOUT=1,NCHANS=$(MAXFRAMES)")
dbLoadRecords("NDROIStatN.template",  "P=$(PREFIX),R=MCA$(CHAN)ROI:14:,PORT=ROISTAT$(CHAN),ADDR=13,TIMEOUT=1,NCHANS=$(MAXFRAMES)")
dbLoadRecords("NDROIStatN.template",  "P=$(PREFIX),R=MCA$(CHAN)ROI:15:,PORT=ROISTAT$(CHAN),ADDR=14,TIMEOUT=1,NCHANS=$(MAXFRAMES)")
dbLoadRecords("NDROIStatN.template",  "P=$(PREFIX),R=MCA$(CHAN)ROI:16:,PORT=ROISTAT$(CHAN),ADDR=15,TIMEOUT=1,NCHANS=$(MAXFRAMES)")
dbLoadRecords("NDROIStatN.template",  "P=$(PREFIX),R=MCA$(CHAN)ROI:17:,PORT=ROISTAT$(CHAN),ADDR=16,TIMEOUT=1,NCHANS=$(MAXFRAMES)")
dbLoadRecords("NDROIStatN.template",  "P=$(PREFIX),R=MCA$(CHAN)ROI:18:,PORT=ROISTAT$(CHAN),ADDR=17,TIMEOUT=1,NCHANS=$(MAXFRAMES)")
dbLoadRecords("NDROIStatN.template",  "P=$(PREFIX),R=MCA$(CHAN)ROI:19:,PORT=ROISTAT$(CHAN),ADDR=18,TIMEOUT=1,NCHANS=$(MAXFRAMES)")
dbLoadRecords("NDROIStatN.template",  "P=$(PREFIX),R=MCA$(CHAN)ROI:20:,PORT=ROISTAT$(CHAN),ADDR=19,TIMEOUT=1,NCHANS=$(MAXFRAMES)")
dbLoadRecords("NDROIStatN.template",  "P=$(PREFIX),R=MCA$(CHAN)ROI:21:,PORT=ROISTAT$(CHAN),ADDR=20,TIMEOUT=1,NCHANS=$(MAXFRAMES)")
dbLoadRecords("NDROIStatN.template",  "P=$(PREFIX),R=MCA$(CHAN)ROI:22:,PORT=ROISTAT$(CHAN),ADDR=21,TIMEOUT=1,NCHANS=$(MAXFRAMES)")
dbLoadRecords("NDROIStatN.template",  "P=$(PREFIX),R=MCA$(CHAN)ROI:23:,PORT=ROISTAT$(CHAN),ADDR=22,TIMEOUT=1,NCHANS=$(MAXFRAMES)")
dbLoadRecords("NDROIStatN.template",  "P=$(PREFIX),R=MCA$(CHAN)ROI:24:,PORT=ROISTAT$(CHAN),ADDR=23,TIMEOUT=1,NCHANS=$(MAXFRAMES)")
dbLoadRecords("NDROIStatN.template",  "P=$(PREFIX),R=MCA$(CHAN)ROI:25:,PORT=ROISTAT$(CHAN),ADDR=24,TIMEOUT=1,NCHANS=$(MAXFRAMES)")
dbLoadRecords("NDROIStatN.template",  "P=$(PREFIX),R=MCA$(CHAN)ROI:26:,PORT=ROISTAT$(CHAN),ADDR=25,TIMEOUT=1,NCHANS=$(MAXFRAMES)")
dbLoadRecords("NDROIStatN.template",  "P=$(PREFIX),R=MCA$(CHAN)ROI:27:,PORT=ROISTAT$(CHAN),ADDR=26,TIMEOUT=1,NCHANS=$(MAXFRAMES)")
dbLoadRecords("NDROIStatN.template",  "P=$(PREFIX),R=MCA$(CHAN)ROI:28:,PORT=ROISTAT$(CHAN),ADDR=27,TIMEOUT=1,NCHANS=$(MAXFRAMES)")
dbLoadRecords("NDROIStatN.template",  "P=$(PREFIX),R=MCA$(CHAN)ROI:29:,PORT=ROISTAT$(CHAN),ADDR=28,TIMEOUT=1,NCHANS=$(MAXFRAMES)")
dbLoadRecords("NDROIStatN.template",  "P=$(PREFIX),R=MCA$(CHAN)ROI:30:,PORT=ROISTAT$(CHAN),ADDR=29,TIMEOUT=1,NCHANS=$(MAXFRAMES)")
dbLoadRecords("NDROIStatN.template",  "P=$(PREFIX),R=MCA$(CHAN)ROI:31:,PORT=ROISTAT$(CHAN),ADDR=30,TIMEOUT=1,NCHANS=$(MAXFRAMES)")
dbLoadRecords("NDROIStatN.template",  "P=$(PREFIX),R=MCA$(CHAN)ROI:32:,PORT=ROISTAT$(CHAN),ADDR=31,TIMEOUT=1,NCHANS=$(MAXFRAMES)")
dbLoadRecords("NDROIStatN.template",  "P=$(PREFIX),R=MCA$(CHAN)ROI:33:,PORT=ROISTAT$(CHAN),ADDR=32,TIMEOUT=1,NCHANS=$(MAXFRAMES)")
dbLoadRecords("NDROIStatN.template",  "P=$(PREFIX),R=MCA$(CHAN)ROI:34:,PORT=ROISTAT$(CHAN),ADDR=33,TIMEOUT=1,NCHANS=$(MAXFRAMES)")
dbLoadRecords("NDROIStatN.template",  "P=$(PREFIX),R=MCA$(CHAN)ROI:35:,PORT=ROISTAT$(CHAN),ADDR=34,TIMEOUT=1,NCHANS=$(MAXFRAMES)")
dbLoadRecords("NDROIStatN.template",  "P=$(PREFIX),R=MCA$(CHAN)ROI:36:,PORT=ROISTAT$(CHAN),ADDR=35,TIMEOUT=1,NCHANS=$(MAXFRAMES)")
dbLoadRecords("NDROIStatN.template",  "P=$(PREFIX),R=MCA$(CHAN)ROI:37:,PORT=ROISTAT$(CHAN),ADDR=36,TIMEOUT=1,NCHANS=$(MAXFRAMES)")
dbLoadRecords("NDROIStatN.template",  "P=$(PREFIX),R=MCA$(CHAN)ROI:38:,PORT=ROISTAT$(CHAN),ADDR=37,TIMEOUT=1,NCHANS=$(MAXFRAMES)")
dbLoadRecords("NDROIStatN.template",  "P=$(PREFIX),R=MCA$(CHAN)ROI:39:,PORT=ROISTAT$(CHAN),ADDR=38,TIMEOUT=1,NCHANS=$(MAXFRAMES)")
dbLoadRecords("NDROIStatN.template",  "P=$(PREFIX),R=MCA$(CHAN)ROI:40:,PORT=ROISTAT$(CHAN),ADDR=39,TIMEOUT=1,NCHANS=$(MAXFRAMES)")
dbLoadRecords("NDROIStatN.template",  "P=$(PREFIX),R=MCA$(CHAN)ROI:41:,PORT=ROISTAT$(CHAN),ADDR=40,TIMEOUT=1,NCHANS=$(MAXFRAMES)")
dbLoadRecords("NDROIStatN.template",  "P=$(PREFIX),R=MCA$(CHAN)ROI:42:,PORT=ROISTAT$(CHAN),ADDR=41,TIMEOUT=1,NCHANS=$(MAXFRAMES)")
dbLoadRecords("NDROIStatN.template",  "P=$(PREFIX),R=MCA$(CHAN)ROI:43:,PORT=ROISTAT$(CHAN),ADDR=42,TIMEOUT=1,NCHANS=$(MAXFRAMES)")
dbLoadRecords("NDROIStatN.template",  "P=$(PREFIX),R=MCA$(CHAN)ROI:44:,PORT=ROISTAT$(CHAN),ADDR=43,TIMEOUT=1,NCHANS=$(MAXFRAMES)")
dbLoadRecords("NDROIStatN.template",  "P=$(PREFIX),R=MCA$(CHAN)ROI:45:,PORT=ROISTAT$(CHAN),ADDR=44,TIMEOUT=1,NCHANS=$(MAXFRAMES)")
dbLoadRecords("NDROIStatN.template",  "P=$(PREFIX),R=MCA$(CHAN)ROI:46:,PORT=ROISTAT$(CHAN),ADDR=45,TIMEOUT=1,NCHANS=$(MAXFRAMES)")
dbLoadRecords("NDROIStatN.template",  "P=$(PREFIX),R=MCA$(CHAN)ROI:47:,PORT=ROISTAT$(CHAN),ADDR=46,TIMEOUT=1,NCHANS=$(MAXFRAMES)")
dbLoadRecords("NDROIStatN.template",  "P=$(PREFIX),R=MCA$(CHAN)ROI:48:,PORT=ROISTAT$(CHAN),ADDR=47,TIMEOUT=1,NCHANS=$(MAXFRAMES)")

